﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Fuel_Economy_with_TryParse
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void calculateButton_Click(object sender, EventArgs e)
        {
            double miles;     // Przechowuje liczbę przejechanych mil.
            double gallons;   // Przechowuje liczbę spalonych galonów paliwa.
            double mpg;       // Przechowuje obliczoną wartość MPG.
            
            // Weryfikacja wartości kontrolki milesTextBox control. 
            if (double.TryParse(milesTextBox.Text, out miles))
            {
                // Weryfikacja wartości kontrolki gallonsTextBox control. 
                if (double.TryParse(gallonsTextBox.Text, out gallons))
                {
                    // Obliczenie wartości MPG. 
                    mpg = miles / gallons;
                    
                    // Wyświetlenie wartości MPG w kontrolce mpgLabel. 
                    mpgLabel.Text = mpg.ToString("n1");
                }
                else
                {
                    // Wyświetlenie komunikatu błędu dla kontrolki gallonsTextBox.
                    MessageBox.Show("Nieprawidłowa liczba spalonych galonów paliwa.");
                }
            }
            else 
            {
                // Wyświetlenie komunikatu błędu dla kontrolki milesTextBox. 
                MessageBox.Show("Nieprawidłowa liczba przejechanych mil.");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
